$(document).ready(function() {
	
    //alert("Holaaaaaaaaaa2222"); 
	// Abre modal de mensaje en vistas
	document.addEventListener("DOMContentLoaded", () => {

		let dimissAlert = document.getElementById("dimissAlert").value;

		if (dimissAlert == 1) {

			setTimeout(function() {

				$("#message").remove();
			}, 5000);
		}
	});


	// Check quantity of tickets selected
	function checkTickets() {

		var loc = $('input:radio[name=locId]:checked').val();
		var qty = $('#qtyvalue').val();
		var url = $('#qtyvalue').attr('data-url');
		var ocid = "";

		if($('#ocid').val()) {

			ocid = "&ocid=" + $('#ocid').val();
		}
		$.ajax({
			url: url,
			data: "loc="+loc+"&qty="+qty+ocid,
			type: "POST",
			success: function(data){

				var json = JSON.parse(data);
				response = json.result;
				if(response == "forbidden"){

					$('#qtyAlert').html("<p id='forbidden'>La cantidad elegida supera el m&aacute;ximo permitido</p>");
					$(':input[type="submit"]').prop('disabled', true);
				} else {

					$('#forbidden').remove();
					$(':input[type="submit"]').prop('disabled', false);
				}
			}	
		});
	}
	// Gets click event on element
	$('.qtybutton').click(checkTickets);


	// muestra el total del valor del boleto en vista de checkout
	function calculaTotal() {

		var url = $(this).data('url');

		$.ajax({
			url: url,
			datatype: 'text json',
			success: function(data) {

				data = JSON.parse(data);

				var qty =  $('#qtyvalue').val();
				var valorCS = (data.locavabo * data.locapoco) / 100;
			    var ivaCS = (valorCS * data.cavaaux1) / 100;
			    // var valorTotalCS = Math.ceil((valorCS + ivaCS)/100) * 100;
				var valorTotalCS = Math.ceil(valorCS + ivaCS);
				var totalTicket = Number(data.locavabo) + (valorTotalCS);

				var totalCeil = Math.ceil(totalTicket / 100) * 100;
				
				$('#qty').html(qty);
				$('#locanomb').html(data.locanomb);
				$('#valbol').html(new Intl.NumberFormat().format(data.locavabo));
				$('#valcoser').html(new Intl.NumberFormat('en-US').format(valorTotalCS));
				$('#valtotal').html(new Intl.NumberFormat().format(totalCeil));

				if($('#qtyblock').css('display', 'none')) {

					$('#qtyblock').css('display', 'flex')
				}
			}
		});
	}
	$('input[type=radio][name=locId]').change(calculaTotal);


	// Funcion que muestra el total de boletos y precio
	function getQty() {

		var qty =  $('#qtyvalue').val();
		var valbol = parseInt($('#valbol').text().replace('.','')) + parseInt($('#valcoser').text().replace(',',''));
		var valqty =  Math.ceil((qty * valbol) / 100) * 100;

		$('#qty').html(qty);
		$('#valtotal').html(new Intl.NumberFormat().format(valqty));
	}
	$('.qtybutton').click(getQty);


	// evita cambiar el valor de la cantidad d entradas por teclado, solo botones
	$('#qtybutton').keypress(function(event){
        event.preventDefault();
    });


	// Verifica si los valores de contraseña coinciden
    function verificaPass() {

        var pass1 = $('#pass1').val();
        var pass2 = $("#pass2").val();
        if( pass2 != pass1 ) {

            $("#alertpass").text('Las contraseñas deben coincidir');
            $(':input[type="submit"]').prop('disabled', true);
        } else {

            $('#alertpass').empty();
            $(':input[type="submit"]').prop('disabled', false);
        }
		
		//Valido longitudes
        if( pass2.length <8 || pass1.length <8 ) {

            $("#alertpass").text('Las contraseñas deben tener minimo 8 caracteres');
            $(':input[type="submit"]').prop('disabled', true);
        } else {

            $('#alertpass').empty();
            $(':input[type="submit"]').prop('disabled', false);
        }		
		/*
		//(?:.*[A-Z]){2}
		//pattern="(?=.*\d)(?=.*[a-záéíóúüñ]).*[A-ZÁÉÍÓÚÜÑ].*"
		regex = /(?:.*[A-Z]){1}/; // Una Mayuscula
		//regex = /(?=(?:.*[A-Z]){1})\S{8,}/; // (?=(?:.*[A-Z]){1});	
		if(regex.test(pass1)) {
 
            $("#alertpass").text('Las contraseñas deben tener una letra Mayuscula');
            $(':input[type="submit"]').prop('disabled', true);
        } else {
            
            $('#alertpass').empty();
            $(':input[type="submit"]').prop('disabled', false);
        }
		
		if(regex.test(pass2)) {
            $("#alertpass2").text('Las contraseñas deben tener una letra Mayuscula');
            $(':input[type="submit"]').prop('disabled', true);
        } else {

            $('#alertpass2').empty();
            $(':input[type="submit"]').prop('disabled', false);
        }		
		
		*/
		
		
    }
    $("#pass1").keyup(verificaPass);
    $("#pass2").keyup(verificaPass);


    // modal para elegir metodo de pago
	function payMethodsModal() {

		var url=$(this).attr('data-url');
		$.ajax({

			url:url,
			success:function(datos){

				$("#contenidoModal").html(datos);
				$("#modal").modal('show');
			},
			error: function(XMLHttpRequest, textStatus, errorThrown) { 

		        alert("Status: " + textStatus); alert("Error: " + errorThrown); 
		    }       
		});
	}
	$("#btn-modal").click(payMethodsModal);


    // Función de copiado de url de evento 
	function copyToClipboard() {

		var $temp = $("<input>");
		var $url = $(location).attr('href');

		$("body").append($temp);
		$temp.val($url).select();
		document.execCommand("copy");
		$temp.remove();
		$("#copied").text("¡Enlace copiado! Ya puedes enviar este evento a quien desees.");
	}
	$('#clipboard').click(copyToClipboard);

	// muestra contraseña escrita
	function showPassword(){
  
		// Check the checkbox state
		if($("#pass").attr("type","password")){
		 // Changing type attribute
		 $("#pass").attr("type","text");
		 // Change the Text
		 $("#togglePass").attr('class','fas fa-eye-slash');
		}else{
		 // Changing type attribute
		 $("#pass").attr("type","password");
		 // Change the Text
		 $("#togglePass").attr('class','fas fa-eye');
		}

	}
	$("#togglePass").mousedown(showPassword);
	$("#togglePass").mouseup(showPassword);

	// JVALIDATE forms
	jQuery.validator.addMethod("ContainsALetter", function (value) { 
        return /^[a-zA-Z]/i.test(value); 
	}, 'Debe contener al menos una letra y que sea mayuscula');

	/*
	jQuery.validator.addMethod("ContainsOneUpperLetter", function (value) { 
        return /(?:.*[A-Z]){1}/.test(value); 
	}, 'Debe contener al menos una letra MAYUSCULA');
	*/
	jQuery.validator.addMethod("valueNotEquals", function(value, element, arg){
		return arg !== value;
	}, "El campo no debe estar vacío");

	$( "#signupForm" ).validate( {

		validClass: "valid",
		errorClass: "invalid",
		rules: {
			name: {
				required: true,
				lettersonly: true,
				minlength: 3,
			},
			last_name: {
				required: true,
				lettersonly: true,
				minlength: 3,
			},
			email1: {
				required: true,
				email: true
			},
			phone1: {
				required: true,
				digits: true,
				minlength: 10
			},
			pass1: {
				required: true,
				minlengthN: 8				
			},
			pass2: {
				required: true,
				minlengthN: 8,
				equalTo: "#pass1"
			},
			country: {
				required: true,
				valueNotEquals: "default"
			},
			bal: "required"
		},
		messages: {
			name: {
				required: "Ingresa tu nombre",
				minlength: "Debe contener al menos 3 letras"
			},
			last_name: {
				required: "Ingresa tu apellido",
				minlength: "Debe contener al menos 5 letras"
			},
			pass1: {
				required: "Ingresa una contraseña",
				minlengthN: "Debe contener al menos 8 caractéres"
			},
			pass2: {
				required: "Confirma tu contraseña",
				minlengthN: "Debe contener al menos 8 caractéres ",
				equalTo: "Las contraseñas deben coincidir"
			},
			phone1: {
				required: "Ingresa tu número celular",
				digits: "Solo se admiten números",
				minlength: "Debe tener al menos 10 números"
			},
			email1: {
				email: "Ingresa una dirección de correo válida",
				required: "Ingresa tu dirección de correo"
			},
			country: {
				valueNotEquals: "Debes elegir un país"
			},
			bal: "Debes aceptar los términos y condiciones"
		}
	} );

	$( "#loginForm" ).validate( {
		validClass: "valid",
		errorClass: "invalid",
		rules: { 
			userMail: {
				required: true
			},
			pass: {
				required: true,
				minlengthN: 8	
			}
		},
		messages: {
			userMail: "Ingresa tu correo o número registrado", 
			pass: "Ingresa tu contraseña, minimo 8 caracteres " 
		}
	} );

	$( "#checkoutForm" ).validate( {

		validClass: "valid",
		errorClass: "invalid",
		rules: {
			qtybutton: {
				required: true,
				digits: true,
				min: 1
			}
		},
		messages: {
			qtybutton: {
				required: "Este campo es obligatorio",
				min: "Debes tener al menos un ticket seleccionado"
			}
		}
	} );

	$("#activateForm").validate( {

		validClass: "valid",
		errorClass: "invalid",
		rules: {
			userMail: {
				required: true,
				email: true
			},
			pass: {
				required: true,
				minlengthN: 8
			}
		},
		messages: {
			userMail: {
				required: "Este campo es obligatorio",
				email: "Ingresa una dirección de correo válida"
			},
			pass: {
				required: "Este campo es obligatorio",
				minlengthN: "Debe contener al menos 8 caractéres"
			}
		}
	} );

	$('#transfernumber').on('keyup', function() {

		var tnumber = $(this).val();
		var regex = new RegExp("[0-9]");
		if(tnumber.length < 10) {

				$(this).html('<label for="transfernumber" id="transfernumber_error">Debe tener al menos 10 números</label>');
		} else if (!regex.test(tnumber)) {

			if($('#transfernumber_error').length > 0) { 

				$('#transfernumber_error').remove();
				$(this).html('<label for="transfernumber" id="transfernumber_error">Solo se admiten números</label>');
			} else {

				$(this).html('<label for="transfernumber" id="transfernumber_error">Solo se admiten números</label>');
			}
		} else {

			if($('#transfernumber_error').length > 0) {

				$('#transfernumber_error').remove();
			}
		}
	});

	$('#click-me-nequi-cancel').click(function () {
		swal.close();
		throwInputData();
	});
	
	$('#click-me-nequi-cancel2').click(function () {
		swal.close();
		throwInputData();
	});
	//alert("Holaaaaaaaaaa");
	var wrapper = $('.waybox-button');
	wrapper.html('Wompi');
	//alert("Holaaaaaaaaa 3 : " + wrapper);	
});

;