<?php
class Conexion {

	// Variables privadas para que solamente esta clase 'Connection' pueda usar
	private $server;
	private $user;
	private $pass;
	private $port;
	private $database;
	private $link;

	// Instanciar las funciones 'setConnect' y 'connect'
	function __construct() {

		$this->setConnect();
		$this->connect();
	}

	// Añadir los valores de las variables 'conf.php' a la función 'setConnect'
	private function setConnect()  {

		require_once '../lib/conf/conf.php';

		$this->server=$server;
		$this->user=$user;
		$this->pass=$pass;
		$this->port=$port;
		$this->database=$database;
	}

	// Función conectar 'connect' 
	private function connect() {

		try {

			$dsn="mysql:host=$this->server;dbname=$this->database; charset=utf8mb4; port=$this->port";

			$mOptions = [
				\PDO::ATTR_ERRMODE            => \PDO::ERRMODE_EXCEPTION,
				\PDO::ATTR_DEFAULT_FETCH_MODE => \PDO::FETCH_ASSOC,
				\PDO::ATTR_EMULATE_PREPARES   => false,
			];
			
			$this->link= new PDO($dsn, $this->user, $this->pass, $mOptions);
			
		} catch (PDOException $e) {

			echo 'Falló la conexión: ' . $e->getMessage();
		}
	}

	// Función que nos retorna la conexión 'link'
	public function getConnect() {

		return $this->link;
	}

	// Función para cerrar la conexión a la database
	public function close() {

		$this->link = null;
	}
}
?>   
