<?php
include_once "../model/access/AccessModel.php";

class AccessController
{

	private $obj;
	public function __construct()
	{

		$this->obj = new AccessModel();
	}

	# Muestra formulario de logueo
	public function showLogin()
	{

		include_once "../view/access/login.php";
	}

	# Consulta las credenciales del usuario para su logueo en la plataforma
	public function login()
	{

		$user = $_POST['userMail'];
		$pass = $_POST['pass'];
		if ($userLog = $this->obj->login($user, $pass)) {

			if ($userLog['usuaesta'] == 6) {

				$_SESSION = array(
					'id' 		=> $userLog["usuaid"],
					'role' 	=> $userLog["usroroid"],
					'key' 	=> $userLog["usuakey"],
					'nombre' 	=> $userLog["usuanomb"] . " " . $userLog["usuaapel"],
					'celular' => $userLog["usuanudi"],
					'email' 	=> $userLog["usuaemai"],
					'password' 	=> $userLog["usuapass"],
					'activado' 	=> $userLog["usuaesta"],
					'validar'  	=> true
				);

				if (!empty($_POST["rememberpassword"])) {
					setcookie("member_login", $_POST["rememberpassword"], time() + (10 * 365 * 24 * 60 * 60));
				} else {
					if (isset($_COOKIE["member_login"])) {
						setcookie("member_login", "");
					}
				}

				if (isset($_POST['idE'])) {

					redirect(getUrl("events", "Events", "showCheckout", array("idE" => $_POST['idE'])));
				} else {

					redirect("index.php");
				}
			} elseif ($userLog['usuaesta'] == 8) {

				# Se instancia la clase para enviar correo de activacion
				include_once "../controller/mailing/MailingController.php";

				# Envio el objeto con la instancia a la BD
				$mailing = new MailingController($this->obj);

				# Cargo la plantilla deseada para el envio del correo - activacion
				$gethtml = $mailing->builtHtmlRegisterActivar($userLog['usuanomb'], $userLog['usuakey']);

				# Envio el correo con los parametros de envio
				if ($mailing->sendmail("Activa tu cuenta Qubit", $userLog["usuaemai"], $gethtml)) {

					# Si el usuario es registrado pero no activo, mostrara un mensaje
					$_SESSION['message'] = 1;
					$_SESSION['message_icon'] = "info";
					$_SESSION['message_text'] = "Hemos enviado un mail de activaci&oacute;n a tu direcci&oacute;n de correo registrada";
					#variable de sesion para loguear al activar
					$_SESSION['validateMail'] = $userLog["usuaemai"];
					$_SESSION['validatePass'] = $pass;

					if (isset($_POST['idE'])) {

						$_SESSION['idE'] = $_POST['idE'];
					}

					redirect(getUrl("access", "Access", "showActivateUser", false, "access"));
				}
			} else {

				$_SESSION['message'] = 1;
				$_SESSION['message_icon'] = "warning";
				$_SESSION['message_text'] = "¡Tu cuenta se encuentra inactiva, comunicate con nosotros si deseas reactivarla!";

				redirect(getUrl("access", "Access", "showLogin", false, "access"));
			}
		} else {

			$_SESSION['message'] = 1;
			$_SESSION['message_icon'] = "error";
			$_SESSION['message_text'] = "¡Los datos son incorrectos, verificalos e intenta nuevamente!";

			redirect(getUrl("access", "Access", "showLogin", false, "access"));
		}
	}

	#termina la sesión del usuario
	public function logout()
	{

		session_destroy();
		redirect("index.php");
	}

	# Muestra formulario de registro
	public function showRegistry()
	{

		$country = $this->obj->getCountries();

		include_once "../view/access/registry.php";
	}

	#registra nuevos usuarios
	public function registry()
	{

		$email = $_POST["email1"];
		$celular = $_POST["phone1"];
		$celular = str_replace(" ", "", $celular);  // Jfmi 22 sep 2022 limpia espacios
		$pass1 = $_POST["pass1"];
		$pass2 = $_POST["pass2"];
		$cntry = $_POST["country"];
		$key = $this->generaCodigoController();
		$pass1 = str_replace(" ", "", $pass1); // Jfmi 19 jun 2022 limpia espacios
		$pass2 = str_replace(" ", "", $pass2); // Jfmi 19 jun 2022 limpia espacios

		if (!is_numeric($celular)) // Jfmi 22 sep 2022 valida que sean numero por si se pasa la validacion del HTML
		{
			$_SESSION['message'] = 1;
			$_SESSION['message_icon'] = "error";
			$_SESSION['message_text'] = "Celular ingresado no es valido.";

			redirect(getUrl("access", "Access", "showRegistry", false, "access"));
		}

		//if($pass1 == $pass2 && strlen($pass1) >= 8 && preg_match('/[a-zA-Z]/', $pass1) && filter_var($email, FILTER_VALIDATE_EMAIL) && strlen($celular) >= 10) 
		if ($pass1 == $pass2 && strlen($pass1) >= 8 && filter_var($email, FILTER_VALIDATE_EMAIL) && strlen($celular) >= 10) //JFMI 23 feb 2023
		{

			if ($getUser = $this->obj->getUser($email, $celular) ||
				$getemail = $this->obj->validEmailUser($email) || // Jfmi 19 jun 2022
				$getTelefono = $this->obj->validTelefonoUser($celular) // Jfmi 19 jun 2022

			) {

				# Si el usuario ya se encuentra registrado, redirecciona y muestra mensaje
				$_SESSION['message'] = 1;
				$_SESSION['message_icon'] = "warning";
				$_SESSION['message_text'] = "La direcci&oacute;n de correo o n&uacute;mero celular ya se encuentra registrada";

				redirect(getUrl("access", "Access", "showRegistry", false, "access"));
			} else {

				$userData = array(
					'name' => $_POST["name"],
					'last_name' => $_POST["last_name"],
					'celular' => $celular,
					'country' => $cntry,
					'email' => $email,
					'password' => hash('sha256', $pass1),
					'usuacate' => 11,
					'activado' => 6,
					'key' => $key
				);

				# Registra los datos del cliente en la tabla usuarios
				if ($idRegistry = $this->obj->createUser($userData)) {

					if ($createUserRole = $this->obj->createUserRole($idRegistry)) {

						# Se instancia la clase para enviar correo de activacion
						include_once "../controller/mailing/MailingController.php";

						# Envio el objeto con la instancia a la BD
						$mailing = new MailingController($this->obj);

						# Cargo la plantilla deseada para el envio del correo
						$gethtml = $mailing->builtHtmlRegister($_POST["name"], $email, $celular);

						# Envio el correo con los parametros de envio
						if ($mailing->sendmail("Bienvenido A Qubit Tickets", $email, $gethtml)) {

							# Si el usuario es registrado, redirecciona y muestra mensaje
							$_SESSION['message'] = 1;
							$_SESSION['message_icon'] = "success";
							$_SESSION['message_text'] = "¡La cuenta ha sido registrada con &eacute;xito!";

							redirect(getUrl("access", "Access", "showLogin", false, "access"));
						}
					}
				} else {

					# Si el usuario mp es registrado, redirecciona y muestra mensaje
					$_SESSION['message'] = 1;
					$_SESSION['message_icon'] = "error";
					$_SESSION['message_text'] = "No ha sido posible realizar el registro";

					redirect(getUrl("access", "Access", "showRegistry", false, "access"));
				}
			}
		} else {

			$_SESSION['message'] = 1;
			$_SESSION['message_icon'] = "error";
			$_SESSION['message_text'] = "No ha sido posible realizar el registro";

			redirect(getUrl("access", "Access", "showRegistry", false, "access"));
		}
	}

	# Vista formulario recuperacion de password
	public function showPasswordRecover()
	{

		include_once "../view/access/passwordRecover.php";
	}

	# Metodo para envio de correo de cambio de contraseña
	public function passwordRecover()
	{

		$user = $_POST['user'];
		if ($getUser = $this->obj->getUserRecover($user)) {

			# Se instancia la clase para enviar correo de activacion
			include_once "../controller/mailing/MailingController.php";

			# Envio el objeto con la instancia a la BD
			$mailing = new MailingController($this->obj);

			# Cargo la plantilla deseada para el envio del correo
			$gethtml = $mailing->builtHtmlRegisterPassword("Recupera Tu Contraseña", $getUser['usuakey']);

			# Envio el correo con los parametros de envio y generación de objeto para alert y redireccion
			if ($mailing->sendmail($getUser['usuanomb'], $getUser['usuaemai'], $gethtml)) {

				$_SESSION['message'] = 1;
				$_SESSION['message_icon'] = "info";
				$_SESSION['message_text'] = "¡Hemos enviado un correo con el c&oacute;digo de recuperación!";

				redirect(getUrl("access", "Access", "showNewPassword", false, "access"));
			} else {

				$_SESSION['message'] = 1;
				$_SESSION['message_icon'] = "warning";
				$_SESSION['message_text'] = "¡Oops! Hemos tenido un error al enviar el correo, intenta nuevamente.";

				redirect(getUrl("access", "Access", "showPasswordRecover", false, "access"));
			}
		} else {

			$_SESSION['message'] = 1;
			$_SESSION['message_icon'] = "error";
			$_SESSION['message_text'] = "¡Oops! El usuario no existe o no se encuentra activo";

			redirect(getUrl("access", "Access", "showPasswordRecover", false, "access"));
		}
	}

	# Muestra campos para registro de nuevo password
	public function showNewPassword()
	{

		include_once "../view/access/setNewPassword.php";
	}

	# Envia el nuevo password que el cliente ha digitado.
	public function setNewPassword()
	{

		$pass1 = $_POST['pass1'];
		$pass2 = $_POST['pass2'];
		$key = $_POST['key'];
		# valida la llave del usuario en BD
		if ($validaKey = $this->obj->getUserKey($key)) {

			if ($pass1 == $pass2) {

				# Valida que se cumplan los parametros minimos para almacenar la nueva contraseña.
				//if(strlen($pass1) >= 8 && preg_match('/[a-zA-Z]/', $pass1)) {
				if (strlen($pass1) >= 8) { //jfmi 23 feb 2023

					# Codifica nuevo password.
					$nPass = hash('sha256', $pass1);
					if ($setNewPass = $this->obj->setNewPassword($validaKey['usuaid'], $nPass)) {

						# genera la nueva llave de usuario.
						$newKey = $this->generaCodigoController();

						# Actualiza la nueva llave del usuario.
						if ($setNewKey = $this->obj->setNewKey($validaKey['usuaid'], $newKey)) {

							# Si el usuario es registrado, redirecciona y muestra mensaje
							$_SESSION['message'] = 1;
							$_SESSION['message_icon'] = "success";
							$_SESSION['message_text'] = "¡La contraseña ha sido modificada con &eacute;xito!";

							redirect(getUrl("access", "Access", "showLogin", false, "access"));
						}
					}
				}
			}
		}
	}

	# Muestra el formulario de activacion de usuario
	public function showActivateUser()
	{

		$valMail = $_SESSION['validateMail'];
		$valPass = $_SESSION['validatePass'];

		if ($_SESSION['idE']) {

			$idE = $_SESSION['idE'];
		}

		include_once "../view/access/activateUser.php";
	}

	# Captura la data, activa al usuario y llama la funcion login del mismo controlador
	public function activateUser()
	{

		# libero variables de sesion para la activacion
		unset($_SESSION['validateMail']);
		unset($_SESSION['validatePass']);
		if ($_SESSION['idE']) {

			unset($_SESSION['idE']);
		}

		$user = $_POST['userMail'];
		$pass = $_POST['pass'];
		$key = $_POST['key'];

		if ($this->obj->activateUser($user, $key, 6)) {

			$this->login();
		}
	}

	#Genera fecha y hora
	public static function timestamp()
	{
		date_default_timezone_set('America/Bogota');
		$hoy = date("Y-m-d h:i:s A");
		return $hoy;
	}

	#Genera token
	private function generaCodigoController()
	{

		$key = '';
		$pattern = '1234567890abcdefghijklmnopqrstuvwxyz';
		$max = strlen($pattern) - 1;
		for ($i = 0; $i < 6; $i++) $key .= $pattern[mt_rand(0, $max)];
		return $key;
	}
}
